/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import stormedpanda.simplyjetpacks.SimplyJetpacks;
import stormedpanda.simplyjetpacks.config.SimplyJetpacksConfig;
import stormedpanda.simplyjetpacks.energy.EnergyStorageImpl;
import stormedpanda.simplyjetpacks.energy.IEnergyContainer;
import stormedpanda.simplyjetpacks.handlers.CommonJetpackHandler;
import stormedpanda.simplyjetpacks.handlers.RegistryHandler;
import stormedpanda.simplyjetpacks.hud.IHUDInfoProvider;
import stormedpanda.simplyjetpacks.item.JetpackArmorMaterial;
import stormedpanda.simplyjetpacks.item.JetpackType;
import stormedpanda.simplyjetpacks.model.JetpackModel;
import stormedpanda.simplyjetpacks.particle.JetpackParticleType;
import stormedpanda.simplyjetpacks.util.JetpackUtil;
import stormedpanda.simplyjetpacks.util.KeyboardUtil;
import stormedpanda.simplyjetpacks.util.NBTUtil;
import stormedpanda.simplyjetpacks.util.SJTextUtil;

public class JetpackItem
extends ArmorItem
implements IHUDInfoProvider,
IEnergyContainer {
    private final JetpackType jetpackType;
    public final int tier;

    public JetpackItem(JetpackType jetpackType) {
        super((IArmorMaterial)JetpackArmorMaterial.JETPACK, EquipmentSlotType.CHEST, new Item.Properties().func_200916_a((ItemGroup)SimplyJetpacks.tabSimplyJetpacks));
        this.jetpackType = jetpackType;
        this.tier = jetpackType.getTier();
    }

    public JetpackItem(JetpackType jetpackType, JetpackArmorMaterial material) {
        super((IArmorMaterial)material, EquipmentSlotType.CHEST, new Item.Properties().func_200916_a((ItemGroup)SimplyJetpacks.tabSimplyJetpacks));
        this.jetpackType = jetpackType;
        this.tier = jetpackType.getTier();
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (!player.func_175149_v() && stack == JetpackUtil.getFromBothSlots(player)) {
            this.flyUser(player, stack, this, false);
            if (this.jetpackType.getChargerMode() && this.isChargerOn(stack)) {
                this.chargeInventory(player, stack);
            }
        }
    }

    public JetpackType getJetpackType() {
        return this.jetpackType;
    }

    public boolean isCreative() {
        return this.jetpackType.getName().contains("creative");
    }

    public int func_77619_b() {
        return super.func_77619_b() + this.jetpackType.getEnchantability();
    }

    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || this.isCreative();
    }

    public Rarity func_77613_e(ItemStack stack) {
        return this.jetpackType.getRarity();
    }

    public String getModId() {
        String name = this.jetpackType.getName();
        if (name.contains("mek")) {
            return "mek";
        }
        if (name.contains("ie")) {
            return "ie";
        }
        return "sj";
    }

    public boolean isEngineOn(ItemStack stack) {
        return NBTUtil.getBoolean(stack, "Engine");
    }

    public void toggleEngine(ItemStack stack, PlayerEntity player) {
        boolean current = NBTUtil.getBoolean(stack, "Engine");
        NBTUtil.flipBoolean(stack, "Engine");
        ITextComponent msg = SJTextUtil.getStateToggle("engineMode", !current);
        player.func_146105_b(msg, true);
    }

    public boolean isHoverOn(ItemStack stack) {
        return NBTUtil.getBoolean(stack, "Hover");
    }

    public void toggleHover(ItemStack stack, PlayerEntity player) {
        if (this.jetpackType.getHoverMode()) {
            boolean current = NBTUtil.getBoolean(stack, "Hover");
            NBTUtil.flipBoolean(stack, "Hover");
            ITextComponent msg = SJTextUtil.getStateToggle("hoverMode", !current);
            player.func_146105_b(msg, true);
        }
    }

    public boolean isEHoverOn(ItemStack stack) {
        return NBTUtil.getBoolean(stack, "EmergencyHover");
    }

    public void toggleEHover(ItemStack stack, PlayerEntity player) {
        if (this.jetpackType.getEmergencyHoverMode()) {
            boolean current = NBTUtil.getBoolean(stack, "EmergencyHover");
            NBTUtil.flipBoolean(stack, "EmergencyHover");
            ITextComponent msg = SJTextUtil.getStateToggle("emergencyHoverMode", !current);
            player.func_146105_b(msg, true);
        }
    }

    private void doEHover(ItemStack stack, PlayerEntity player) {
        if (this.jetpackType.getHoverMode()) {
            NBTUtil.setBoolean(stack, "Engine", true);
            NBTUtil.setBoolean(stack, "Hover", true);
            ITextComponent msg = SJTextUtil.getEmergencyText();
            player.func_146105_b(msg, true);
        }
    }

    public boolean isChargerOn(ItemStack stack) {
        return NBTUtil.getBoolean(stack, "Charger");
    }

    public void toggleCharger(ItemStack stack, PlayerEntity player) {
        if (this.jetpackType.getChargerMode()) {
            boolean current = NBTUtil.getBoolean(stack, "Charger");
            NBTUtil.flipBoolean(stack, "Charger");
            ITextComponent msg = SJTextUtil.getStateToggle("chargerMode", !current);
            player.func_146105_b(msg, true);
        }
    }

    public static float getChargeRatio(ItemStack stack) {
        LazyOptional optional = stack.getCapability(CapabilityEnergy.ENERGY);
        if (optional.isPresent()) {
            IEnergyStorage energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new);
            return (float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored();
        }
        return 0.0f;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT nbt) {
        final JetpackItem container = this;
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == CapabilityEnergy.ENERGY) {
                    return LazyOptional.of(() -> new EnergyStorageImpl(stack, container)).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (CapabilityEnergy.ENERGY == null) {
            return;
        }
        SJTextUtil.addBaseInfo(stack, tooltip);
        if (KeyboardUtil.isHoldingShift()) {
            SJTextUtil.addShiftInfo(stack, tooltip);
        } else {
            tooltip.add(SJTextUtil.getShiftText());
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !this.isCreative() && this.getEnergy(stack) > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0f - JetpackItem.getChargeRatio(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 261193;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this));
            if (!this.isCreative()) {
                ItemStack full = new ItemStack((IItemProvider)this);
                NBTUtil.setInt(full, "Energy", this.jetpackType.getEnergyCapacity());
                items.add((Object)full);
            }
        }
    }

    private void setEnergyStored(ItemStack container, int value) {
        NBTUtil.setInt(container, "Energy", MathHelper.func_76125_a((int)value, (int)0, (int)this.getCapacity(container)));
    }

    public int getEnergyReceive() {
        return this.jetpackType.getEnergyPerTickIn();
    }

    public int getEnergyExtract() {
        return this.jetpackType.getEnergyUsage();
    }

    public static ItemStack setParticleId(ItemStack stack, ItemStack particle) {
        String key = particle.func_77977_a().split("item.simplyjetpacks.particle_")[1].toUpperCase();
        int id = JetpackParticleType.valueOf(key).ordinal();
        NBTUtil.setInt(stack, "ParticleID", id);
        return stack;
    }

    public static void setParticleId(ItemStack stack, int id) {
        NBTUtil.setInt(stack, "ParticleID", id);
    }

    public static int getParticleId(ItemStack stack) {
        return stack.func_196082_o().func_74764_b("ParticleID") ? stack.func_196082_o().func_74762_e("ParticleID") : JetpackType.getDefaultParticles(stack);
    }

    public void setThrottle(ItemStack stack, int value) {
        NBTUtil.setInt(stack, "Throttle", value);
    }

    public int getThrottle(ItemStack stack) {
        return stack.func_196082_o().func_74764_b("Throttle") ? stack.func_196082_o().func_74762_e("Throttle") : 100;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return this.jetpackType.getArmorTexture();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A _default) {
        return (A)((Object)new JetpackModel());
    }

    public void useEnergy(ItemStack container, int amount) {
        if (container.func_77978_p() != null || container.func_77978_p().func_74764_b("Energy")) {
            int stored = Math.min(container.func_77978_p().func_74762_e("Energy"), this.getCapacity(container));
            if ((stored -= amount) < 0) {
                stored = 0;
            }
            container.func_77978_p().func_74768_a("Energy", stored);
        }
    }

    public int getEnergyUsage(ItemStack stack) {
        int baseUsage = this.jetpackType.getEnergyUsage();
        int level = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)RegistryHandler.FUEL_EFFICIENCY.get()), (ItemStack)stack);
        return level != 0 ? (int)Math.round((double)(baseUsage * (5 - level)) / 5.0) : baseUsage;
    }

    public void chargeInventory(PlayerEntity player, ItemStack stack) {
        if (!player.func_130014_f_().field_72995_K && (this.getEnergy(stack) > 0 || this.isCreative())) {
            for (ItemStack itemStack : player.func_184214_aD()) {
                this.charge(stack, itemStack);
            }
            for (ItemStack itemStack : player.func_184193_aE()) {
                this.charge(stack, itemStack);
            }
        }
    }

    private void charge(ItemStack jetpack, ItemStack item) {
        LazyOptional optional;
        if (!item.equals(jetpack) && item.getCapability(CapabilityEnergy.ENERGY).isPresent() && (optional = item.getCapability(CapabilityEnergy.ENERGY)).isPresent()) {
            IEnergyStorage energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new);
            if (this.isCreative()) {
                energyStorage.receiveEnergy(1000, false);
            } else {
                this.useEnergy(jetpack, energyStorage.receiveEnergy(this.getEnergyUsage(jetpack), false));
            }
        }
    }

    private void fly(PlayerEntity player, double y) {
        Vector3d motion = player.func_213322_ci();
        player.func_213293_j(motion.func_216370_a(Direction.Axis.X), y, motion.func_216370_a(Direction.Axis.Z));
    }

    public boolean func_77616_k(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof JetpackItem;
    }

    public void flyUser(PlayerEntity player, ItemStack stack, JetpackItem item, Boolean force) {
        if (this.isEngineOn(stack)) {
            boolean hoverMode = this.isHoverOn(stack);
            double hoverSpeed = (Boolean)SimplyJetpacksConfig.invertHoverSneakingBehavior.get() == CommonJetpackHandler.isHoldingDown(player) ? this.jetpackType.getSpeedVerticalHoverSlow() : this.jetpackType.getSpeedVerticalHover();
            boolean flyKeyDown = force != false || CommonJetpackHandler.isHoldingUp(player);
            boolean descendKeyDown = CommonJetpackHandler.isHoldingDown(player);
            double currentAccel = this.jetpackType.getAccelVertical() * (player.func_213322_ci().func_216370_a(Direction.Axis.Y) < 0.3 ? 2.5 : 1.0);
            double currentSpeedVertical = this.jetpackType.getSpeedVertical() * (player.func_70090_H() ? 0.4 : 1.0);
            double speedVerticalHover = this.jetpackType.getSpeedVerticalHover();
            double speedVerticalHoverSlow = this.jetpackType.getSpeedVerticalHoverSlow();
            if (flyKeyDown || hoverMode && !player.func_233570_aj_()) {
                if (!this.isCreative()) {
                    int amount = (int)(player.func_70051_ag() ? Math.round((double)this.getEnergyUsage(stack) * this.jetpackType.getSprintEnergyModifier()) : (long)this.getEnergyUsage(stack));
                    this.useEnergy(stack, amount);
                }
                if (this.getEnergy(stack) > 0 || this.isCreative()) {
                    if (flyKeyDown) {
                        if (!hoverMode) {
                            this.fly(player, Math.min(player.func_213322_ci().func_216370_a(Direction.Axis.Y) + currentAccel, currentSpeedVertical));
                        } else if (descendKeyDown) {
                            this.fly(player, Math.min(player.func_213322_ci().func_216370_a(Direction.Axis.Y) + currentAccel, -speedVerticalHoverSlow));
                        } else {
                            this.fly(player, Math.min(player.func_213322_ci().func_216370_a(Direction.Axis.Y) + currentAccel, speedVerticalHover));
                        }
                    } else {
                        this.fly(player, Math.min(player.func_213322_ci().func_216370_a(Direction.Axis.Y) + currentAccel, -hoverSpeed));
                    }
                    double baseSpeedSideways = this.jetpackType.getSpeedSideways();
                    double sprintSpeedModifier = this.jetpackType.getSprintSpeedModifier();
                    float speedSideways = (float)(player.func_213453_ef() ? baseSpeedSideways * 0.5 : baseSpeedSideways) * ((float)this.getThrottle(stack) / 100.0f);
                    float speedForward = (float)(player.func_70051_ag() ? (double)speedSideways * sprintSpeedModifier : (double)speedSideways) * ((float)this.getThrottle(stack) / 100.0f);
                    if (CommonJetpackHandler.isHoldingForwards(player)) {
                        player.func_213309_a(1.0f, new Vector3d(0.0, 0.0, (double)speedForward));
                    }
                    if (CommonJetpackHandler.isHoldingBackwards(player)) {
                        player.func_213309_a(1.0f, new Vector3d(0.0, 0.0, (double)(-speedSideways * 0.8f)));
                    }
                    if (CommonJetpackHandler.isHoldingLeft(player)) {
                        player.func_213309_a(1.0f, new Vector3d((double)speedSideways, 0.0, 0.0));
                    }
                    if (CommonJetpackHandler.isHoldingRight(player)) {
                        player.func_213309_a(1.0f, new Vector3d((double)(-speedSideways), 0.0, 0.0));
                    }
                    if (!player.func_130014_f_().func_201670_d()) {
                        player.field_70143_R = 0.0f;
                        if (player instanceof ServerPlayerEntity) {
                            ((ServerPlayerEntity)player).field_71135_a.field_147365_f = 0;
                        }
                    }
                }
            }
        }
        if (!(player.field_70170_p.field_72995_K || !this.isEHoverOn(stack) || item.getEnergy(stack) <= 0 && !this.isCreative() || this.isHoverOn(stack) && this.isEngineOn(stack))) {
            if (player.func_213303_ch().func_216370_a(Direction.Axis.Y) < -5.0) {
                this.doEHover(stack, player);
            } else if (!player.func_184812_l_() && player.field_70143_R - 1.2f >= player.func_110143_aJ()) {
                for (int j = 0; j <= 16; ++j) {
                    if (player.func_233570_aj_() || player.func_203007_ba()) continue;
                    this.doEHover(stack, player);
                    break;
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addHUDInfo(ItemStack stack, List<ITextComponent> list) {
        SJTextUtil.addHUDInfoText(stack, list);
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (this.getEnergyReceive() == 0) {
            return 0;
        }
        int energyStored = this.getEnergy(container);
        int energyReceived = Math.min(this.getCapacity(container) - energyStored, Math.min(this.getEnergyReceive(), maxReceive));
        if (!simulate) {
            this.setEnergyStored(container, energyStored + energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (this.getEnergyExtract() == 0) {
            return 0;
        }
        int energyStored = this.getEnergy(container);
        int energyExtracted = Math.min(energyStored, Math.min(this.getEnergyExtract(), maxExtract));
        if (!simulate) {
            this.setEnergyStored(container, energyStored - energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergy(ItemStack container) {
        return container.func_196082_o().func_74762_e("Energy");
    }

    @Override
    public int getCapacity(ItemStack container) {
        return this.jetpackType.getEnergyCapacity();
    }
}

